# provision_rho_grids.py
import argparse, pathlib, numpy as np, yaml

def main():
    ap = argparse.ArgumentParser()
    ap.add_argument("--outdir", default="data/results/vol4_wilson_loop_pipeline_crossover_analysis")
    ap.add_argument("--config", default="configs/default.yaml")
    ap.add_argument("--mode", choices=["uniform","kernel-quantile"], default="uniform")
    args = ap.parse_args()

    cfg = yaml.safe_load(open(args.config,"r",encoding="utf-8"))
    Ls = (cfg.get("adjoint_volume",{}).get("volumes")
          or cfg.get("L_values")
          or cfg.get("L_list"))
    if not Ls:
        raise SystemExit("No L list found (adjoint_volume.volumes or L_values/L_list)")

    outdir = pathlib.Path(args.outdir); outdir.mkdir(parents=True, exist_ok=True)

    for L in sorted(int(L) for L in Ls):
        n = 2*(L**2)
        if args.mode == "uniform":
            rho = np.linspace(0.0, 1.0, num=n, dtype=float)
        else:
            # Use SU2 kernel as a quantile source if present
            kpath = f"data/kernels/kernel_SU2_L{L}.npy"
            try:
                kvals = np.load(kpath).astype(float).ravel()
                ranks = np.argsort(np.argsort(kvals))
                rho = (ranks + 0.5) / ranks.size
            except Exception:
                rho = np.linspace(0.0, 1.0, num=n, dtype=float)
        out = outdir / f"rho_grid_L{L}.npy"
        np.save(out, rho)
        print(f"[OK] wrote {out} (len={rho.size})")

if __name__ == "__main__":
    main()
